/*
 * Decompiled with CFR 0.152.
 */
package entities.missiles.sivir;

import core.states.GameState;
import entities.Entity;
import entities.creatures.CreatureEntity;
import entities.creatures.PlayerCreatureEntity;
import entities.creatures.enemies.SivirEntity;
import entities.missiles.BoomerangMissileEntity;
import java.util.ArrayList;
import util.Config;
import util.ResourceManager;

public final class SivirAbilityQEntity
extends BoomerangMissileEntity {
    private long lastFrameChange;
    private ArrayList<CreatureEntity> entities = new ArrayList();

    public SivirAbilityQEntity(SivirEntity parent, GameState game, int x, int y) {
        super(parent, game, "missiles/sivir/abilityQ", x, y);
        this.removeWhenOutOfArea = false;
        this.moveSpeed = Config.get(Config.sivirAbilityQProjectileSpeed);
        this.phase1Time = Config.get(Config.sivirAbilityQPhase1Time);
        double deltaX = game.getPlayer().getX() - x;
        double deltaY = game.getPlayer().getY() - y;
        double deltaMax = Math.max(Math.abs(deltaX), Math.abs(deltaY));
        this.dx = deltaX / deltaMax * this.moveSpeed;
        this.dy = deltaY / deltaMax * this.moveSpeed;
    }

    @Override
    public void move(long delta) {
        super.move(delta);
        this.lastFrameChange += delta;
        if (this.lastFrameChange > 10L) {
            this.lastFrameChange = 0L;
            this.sprite.rotate(13.0f);
        }
    }

    @Override
    public void phase1IsOver() {
        super.phase1IsOver();
        this.entities.clear();
    }

    @Override
    public void collidedWith(Entity other) {
        if (other instanceof PlayerCreatureEntity && !this.entities.contains(other)) {
            this.entities.add((CreatureEntity)other);
            if (((CreatureEntity)other).hasEffectType("spellshield")) {
                ((CreatureEntity)other).removeEffectByType("spellshield");
            } else {
                ResourceManager.get().playSound("sivir_abilityQ_hit");
                ((CreatureEntity)other).damage(this, Config.get(Config.sivirAbilityQDamage));
            }
        }
        if (!this.phase1 && other == this.parent) {
            this.game.removeEntity(this);
        }
    }
}

